-- Author  : John D P Purba
-- Purpose : Kontroler 

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;
USE IEEE.numeric_std.ALL;
USE WORK.enkrip_pack.ALL;

ENTITY Kontroler IS
	PORT(clock_i	   : IN std_logic;
 		 reset_i	   : IN std_logic;

		 start_i       : IN std_logic;	
		 mux_sel_o     : OUT std_logic;
		 mix_sel_o     : OUT std_logic;
		 add_sel_o     : OUT std_logic;
		 kunci_start_o : OUT std_logic
	);
END Kontroler;

ARCHITECTURE Kontroler_RTL OF Kontroler IS

TYPE state_kontrol IS (nop, busy); 

SIGNAL sig_round       : INTEGER RANGE 0 TO 10;
SIGNAL sig_kontrol     : state_kontrol;

BEGIN

	PROCESS(clock_i, reset_i)
	BEGIN
	
	IF reset_i = '1' THEN
		mux_sel_o<= '0';
		add_sel_o <= '0';
		mix_sel_o <= '0';
		kunci_start_o <= '0';
	ELSIF clock_i'EVENT AND clock_i = '1' THEN
		kunci_start_o <= start_i;
		CASE sig_kontrol IS
			WHEN nop =>
				mux_sel_o <= '0';	
				mix_sel_o <= '0';	
				add_sel_o <= '0';	
			WHEN busy =>
				IF (sig_round < 10) THEN
					mux_sel_o <= '1';	
					mix_sel_o <= '0';	
					add_sel_o <= '0';	
				ELSE
					mux_sel_o <= '1';	
					mix_sel_o <= '1';	
					add_sel_o <= '1';	
				END IF;
		END CASE;
	END IF;
	END PROCESS;

	PROCESS(clock_i, reset_i)
	BEGIN
	
	IF reset_i = '1' THEN
		sig_round <= 0;
		sig_kontrol <= nop;
	ELSIF clock_i'EVENT AND clock_i = '1' THEN
		IF((start_i = '1' or sig_kontrol = busy) AND sig_round /= 10) THEN
			sig_kontrol <= busy;
			sig_round <= sig_round + 1;
		ELSE
			sig_kontrol <= nop;
			sig_round <= 0;
		END IF;
	END IF;
	END PROCESS;

END Kontroler_RTL;














